#!/usr/bin/python
# coding=utf-8
# vim:fileencoding=utf-8

import os


def listFiles(path):
    exclude_exts = set(e.lower() for e in ([".txt"]))
    for root, dirs, files in os.walk(path):
        for file in files:
            if exclude_exts and any(file.lower().endswith(ext) for ext in exclude_exts):
                continue
            print(os.path.join(root, file))


listFiles("")